/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.event;

import net.minecraft.network.chat.ChatMessageContent;
import net.minecraft.network.chat.ChatType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MessageSigner;
import net.minecraft.network.chat.PlayerChatMessage;
import net.minecraftforge.eventbus.api.Cancelable;
import net.minecraftforge.eventbus.api.Event;
import org.jetbrains.annotations.ApiStatus;

@Cancelable
public class ClientChatReceivedEvent
extends Event {
    private Component message;
    private final ChatType.Bound boundChatType;
    private final PlayerChatMessage playerChatMessage;
    private final MessageSigner messageSigner;

    @ApiStatus.Internal
    public ClientChatReceivedEvent(ChatType.Bound boundChatType, Component message, PlayerChatMessage playerChatMessage, MessageSigner messageSigner) {
        this.boundChatType = boundChatType;
        this.message = message;
        this.playerChatMessage = playerChatMessage;
        this.messageSigner = messageSigner;
    }

    private ClientChatReceivedEvent(ChatType.Bound boundChatType, Component message, PlayerChatMessage playerChatMessage) {
        this(boundChatType, message, playerChatMessage, playerChatMessage.m_241067_());
    }

    public Component getMessage() {
        return this.message;
    }

    public void setMessage(Component message) {
        this.message = message;
    }

    public ChatType.Bound getBoundChatType() {
        return this.boundChatType;
    }

    public PlayerChatMessage getPlayerChatMessage() {
        return this.playerChatMessage;
    }

    public MessageSigner getMessageSigner() {
        return this.messageSigner;
    }

    public boolean isSystem() {
        return this.messageSigner.m_241005_();
    }

    public static class System
    extends ClientChatReceivedEvent {
        private final boolean overlay;

        @ApiStatus.Internal
        public System(ChatType.Bound boundChatType, Component message, boolean overlay) {
            super(boundChatType, message, PlayerChatMessage.m_242673_((ChatMessageContent)new ChatMessageContent(message.getString(), message)));
            this.overlay = overlay;
        }

        public boolean isOverlay() {
            return this.overlay;
        }
    }
}

